/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.roadstuff.client.gui.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import tv.mapper.roadstuff.RoadStuff;
import tv.mapper.roadstuff.network.BrushPacket;
import tv.mapper.roadstuff.network.RSNetwork;
import tv.mapper.roadstuff.world.level.block.state.properties.EnumPaintColor;

public class GuiBrush
extends Screen {
    public static final Component title = new TextComponent("Paintbrush");
    private static final int WIDTH = 217;
    private static final int HEIGHT = 205;
    private static final int ROWS = 26;
    private int pattern;
    private int paint;
    private int color;
    private int guiLeft;
    private int guiTop;
    private int selectX;
    private int selectY;
    private int posX;
    private int posY;
    private int scroll = 0;
    private float currentScroll = 0.0f;
    private boolean isScrolling;
    private int[] favorites = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    int favX;
    int favY;
    private TranslatableComponent textTitle = new TranslatableComponent("roadstuff.gui.paintbrush.title");
    private TranslatableComponent textEraser = new TranslatableComponent("roadstuff.message.brush.gui.eraser");
    private TranslatableComponent textPattern = new TranslatableComponent("roadstuff.message.brush.gui.pattern");
    private TranslatableComponent textPaint = new TranslatableComponent("roadstuff.message.brush.gui.paint");
    private TranslatableComponent textColor = new TranslatableComponent("roadstuff.message.brush.gui.color");
    private TranslatableComponent textFav1 = new TranslatableComponent("roadstuff.message.brush.gui.fav1");
    private TranslatableComponent textFav2 = new TranslatableComponent("roadstuff.message.brush.gui.fav2");
    private static final ResourceLocation brush_gui = new ResourceLocation("roadstuff", "textures/gui/brush.png");

    public GuiBrush(int pattern, int paint, int color, float scroll, int[] favorites) {
        super(title);
        this.pattern = pattern;
        this.paint = paint;
        this.color = color;
        this.currentScroll = scroll;
        if (favorites.length == 8) {
            this.favorites = favorites;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiLeft = this.f_96543_ / 2 - 108;
        this.guiTop = this.f_96544_ / 2 - 102;
        this.scroll = (int)(this.currentScroll * 26.0f);
        if (this.scroll < 0) {
            this.scroll = 0;
        } else if (this.scroll > 26) {
            this.scroll = 26;
        }
        int pattern_temp = this.pattern;
        if (this.pattern > 8) {
            pattern_temp = this.pattern - 9 * (this.pattern / 9);
        }
        this.selectX = this.guiLeft + 6 + pattern_temp * 18;
        this.selectY = this.guiTop + 15 + this.pattern / 9 * 18;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        int boxY;
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_96558_(stack, 0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)brush_gui);
        this.m_93228_(stack, this.guiLeft, this.guiTop, 0, 0, 217, 205);
        int j = 0;
        int row = 0;
        for (int i = 0; i < 90; ++i) {
            if (i + this.scroll * 9 >= 324) continue;
            RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("roadstuff", "textures/block/" + (i + 9 * this.scroll) + ".png"));
            GuiBrush.m_93133_((PoseStack)stack, (int)(this.guiLeft + 16 * j + 9 + j * 2), (int)(this.guiTop + 18 + row), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            if (++j < 9) continue;
            j = 0;
            row += 18;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("roadstuff", "textures/block/" + this.pattern + ".png"));
        GuiBrush.m_93133_((PoseStack)stack, (int)(this.guiLeft + 193), (int)(this.guiTop + 18), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        int fav_y = 54;
        for (int i = 0; i < 8; ++i) {
            if (this.favorites[i] != 0) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("roadstuff", "textures/block/" + this.favorites[i] + ".png"));
                GuiBrush.m_93133_((PoseStack)stack, (int)(this.guiLeft + 193), (int)(this.guiTop + fav_y), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
            fav_y += 18;
        }
        if (mouseX > this.guiLeft + 7 && mouseX < this.guiLeft + 171 && mouseY > this.guiTop + 16 && mouseY < this.guiTop + 196) {
            this.posX = Math.toIntExact(Math.round((mouseX - this.guiLeft - 9) / 18) * 18) + this.guiLeft + 9;
            this.posY = Math.toIntExact(Math.round((mouseY - this.guiTop - 17) / 18) * 18) + this.guiTop + 18;
            GuiBrush.m_93172_((PoseStack)stack, (int)this.posX, (int)this.posY, (int)(this.posX + 16), (int)(this.posY + 16), (int)new Color(255, 255, 255, 128).getRGB());
        }
        if (mouseX > this.guiLeft + 191 && mouseX < this.guiLeft + 210 && mouseY > this.guiTop + 52 && mouseY < this.guiTop + 197) {
            this.favX = Math.toIntExact(Math.round((mouseX - this.guiLeft - 12) / 18) * 18) + this.guiLeft + 13;
            this.favY = Math.toIntExact(Math.round((mouseY - this.guiTop - 17) / 18) * 18) + this.guiTop + 18;
            GuiBrush.m_93172_((PoseStack)stack, (int)this.favX, (int)this.favY, (int)(this.favX + 16), (int)(this.favY + 16), (int)new Color(255, 255, 255, 128).getRGB());
        }
        if ((boxY = this.selectY - this.scroll * 18) > this.guiTop && boxY < this.guiTop + 205 - 27) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)brush_gui);
            this.m_93228_(stack, this.selectX, boxY, 234, 234, 22, 22);
        }
        String title = this.textTitle.getString();
        this.f_96547_.m_92883_(stack, title, (float)(this.guiLeft + 108 - this.f_96547_.m_92895_(title) / 2), (float)(this.guiTop + 6), 0x404040);
        RenderSystem.m_157456_((int)0, (ResourceLocation)brush_gui);
        this.m_93228_(stack, this.guiLeft + 217 - 42, (int)((float)(this.guiTop + 18) + 164.0f * this.currentScroll), 232, 0, 12, 15);
        if (this.pattern == 0) {
            this.f_96547_.m_92763_(stack, (Component)this.textEraser, (float)(this.guiLeft + 225), (float)(this.guiTop + 22), new Color(255, 255, 255).getRGB());
        } else {
            this.f_96547_.m_92750_(stack, this.textPattern.getString() + this.pattern, (float)(this.guiLeft + 225), (float)(this.guiTop + 22), new Color(255, 255, 255).getRGB());
        }
        this.f_96547_.m_92750_(stack, this.textPaint.getString() + this.paint, (float)(this.guiLeft + 225), (float)(this.guiTop + 40), new Color(255, 255, 255).getRGB());
        this.f_96547_.m_92750_(stack, this.textColor.getString() + EnumPaintColor.getColorByID(this.color).getNameTranslated(), (float)(this.guiLeft + 225), (float)(this.guiTop + 58), new Color(255, 255, 255).getRGB());
        if (mouseX > this.guiLeft + 7 && mouseX < this.guiLeft + 217 - 43 && mouseY > this.guiTop + 14 && mouseY < this.guiTop + 196) {
            int patternHover = (this.posX - this.guiLeft - 9) / 18 + (this.posY - this.guiTop - 9) / 18 * 9 + this.scroll * 9;
            if (patternHover == 0) {
                this.m_96602_(stack, (Component)this.textEraser, mouseX, mouseY);
            } else {
                TranslatableComponent textPatternDisplay = new TranslatableComponent(this.textPattern.getString() + patternHover);
                this.m_96602_(stack, (Component)textPatternDisplay, mouseX, mouseY);
            }
        } else if (mouseX > this.guiLeft + 191 && mouseX < this.guiLeft + 210 && mouseY > this.guiTop + 52 && mouseY < this.guiTop + 197) {
            int patternHover = (this.favY - this.guiTop - 40) / 18;
            ArrayList<TranslatableComponent> patternTooltipFinal = new ArrayList<TranslatableComponent>();
            if (this.favorites[patternHover] == 0) {
                TranslatableComponent patternTooltip = new TranslatableComponent(this.textFav1.getString());
                TranslatableComponent patternTooltip2 = new TranslatableComponent(this.textFav2.getString());
                patternTooltipFinal.add(patternTooltip);
                patternTooltipFinal.add(patternTooltip2);
            } else {
                TranslatableComponent patternTooltip = new TranslatableComponent(this.textPattern.getString() + this.favorites[patternHover]);
                patternTooltipFinal.add(patternTooltip);
            }
            this.m_169388_(stack, patternTooltipFinal, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseX > (double)(this.guiLeft + 7) && mouseX < (double)(this.guiLeft + 217 - 43) && mouseY > (double)(this.guiTop + 14) && mouseY < (double)(this.guiTop + 196)) {
            if (button == 0) {
                int choice = (this.posX - this.guiLeft - 9) / 18 + (this.posY - this.guiTop - 9) / 18 * 9 + this.scroll * 9;
                if (choice < 324) {
                    this.pattern = choice;
                    this.selectX = this.posX - 3;
                    this.selectY = this.posY + this.scroll * 18 - 3;
                }
                return true;
            }
            if (button == 1) {
                int choice = (this.posX - this.guiLeft - 9) / 18 + (this.posY - this.guiTop - 9) / 18 * 9 + this.scroll * 9;
                if (choice < 324 && !IntStream.of(this.favorites).anyMatch(x -> x == choice) && choice != 0) {
                    int fav;
                    for (fav = 0; this.favorites[fav] != 0 && fav < 7; ++fav) {
                    }
                    if (fav == 7 && this.favorites[7] != 0) {
                        for (int i = 0; i < 7; ++i) {
                            this.favorites[i] = this.favorites[i + 1];
                        }
                        this.favorites[7] = choice;
                    } else {
                        this.favorites[fav] = choice;
                    }
                }
            }
        } else if (mouseX > (double)(this.guiLeft + 191) && mouseX < (double)(this.guiLeft + 210) && mouseY > (double)(this.guiTop + 52) && mouseY < (double)(this.guiTop + 197)) {
            int selectedFav = 0;
            selectedFav = (this.favY - this.guiTop - 40) / 18;
            if (selectedFav >= 0 && selectedFav < 8) {
                if (this.favorites[selectedFav] != 0) {
                    this.pattern = this.favorites[selectedFav];
                }
            } else {
                RoadStuff.LOGGER.warn("Invalid selected pattern! This is not supposed to happen... Please report to https://github.com/MapperTV/roadstuff/issues if you see this.");
            }
        }
        if (button == 0 && this.scrollbarClamp(mouseX, mouseY)) {
            this.isScrolling = true;
        }
        return false;
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.m_6913_() && p_keyPressed_1_ == 256 || this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            RSNetwork.ROADSTUFF_CHANNEL.sendToServer((Object)new BrushPacket(this.pattern, this.currentScroll, this.favorites));
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        this.scroll = (int)((double)this.scroll - p_mouseScrolled_5_);
        if (this.scroll < 0) {
            this.scroll = 0;
        } else if (this.scroll > 26) {
            this.scroll = 26;
        }
        int i = 26;
        this.currentScroll = (float)((double)this.currentScroll - p_mouseScrolled_5_ / (double)i);
        this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
        return true;
    }

    public boolean m_7979_(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.isScrolling) {
            int i = this.guiTop + 18;
            int j = i + 179;
            this.currentScroll = ((float)p_mouseDragged_3_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.scroll = (int)(((double)this.currentScroll + 0.01) * 26.0);
            if (this.scroll < 0) {
                this.scroll = 0;
            }
            return true;
        }
        return super.m_7979_(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        if (p_mouseReleased_5_ == 0) {
            this.isScrolling = false;
        }
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    protected boolean scrollbarClamp(double mouseX, double mouseY) {
        int i = this.guiLeft;
        int j = this.guiTop;
        int k = i + 175;
        int l = j + 18;
        int i1 = k + 13;
        int j1 = l + 179;
        return mouseX >= (double)k && mouseY >= (double)l && mouseX < (double)i1 && mouseY < (double)j1;
    }
}

